ny=1000; % time discretization points (1 period)
nx=100; % space discretization points 

deltay=1/ny;
deltax=1/nx;

x=linspace(0,1,nx+1);
y=linspace(0,1,ny+1);

%% input parameters

phip= -2*pi/9; % angle between spontaneous bending plane and line joining PFR-Ax centers
eta=3.1*4*(2.8^4)/8.4; % viscous/elastic forces ratio 
nu= 20; % PFR/Ax stiffness ratio
periods=15; % # of beating periods to be calculated in the simulation

% target curvature parameters
a0= 7.8;
a1= 7.5;
lambda0=1.85; 
lambda1= 0.1; 
omega1=-0.1;

u_target=zeros(nx+1,ny+1);

lambda = @(x) 2*pi*lambda0*(x + lambda1*sin(pi*x)) ;
omega = @(t)  2*pi*( t + omega1*sin(pi*t) ) ;



for inst= 1:(ny + 1)
  
 u_target(:,inst)= a0*ones(1,nx+1)  - a1*cos( lambda(x) - omega(deltay*(inst-1))); 
   
end

%% derivative operators

D4= diag(1*ones(nx-1,1),-2)  +   ... 
     diag(-4*ones(nx,1),-1) +   ...
     diag(6*ones(nx + 1,1)) +   ...
     diag(-4*ones(nx,1),1) +    ...
     diag(1*ones(nx-1,1),2) + ...
     [-6 ,4+24/3 , -1-30/3 , 17/3 , -3/3 , zeros(1,nx-4) ; ...
     [4 , -6+6/3 , 4-6/3 , -1+2/3 , zeros(1,nx-3) ];...
     [-1 , zeros(1,nx) ];...
     zeros(nx-4,nx+1) ; ...
     [zeros(1,nx-1) , 1 , 0 ];
     [zeros(1,nx-2) , -1 , -4 , 2 ] ];
 
 D40= D4(2:(nx+1),2:(nx+1));
 
 D2h= diag(1*ones(nx,1),-1) +   ...
     diag(-2*ones(nx + 1,1)) +   ...
     diag(1*ones(nx,1),1) + ...
     [[2+3/3 , -1-11/3 ,11/3  , -3/3 , zeros(1,nx-3) ]; ...
     [-1 , 2-2/3  , -1+2/3 , zeros(1,nx-2) ];...
     zeros(nx-2,nx+1) ; ...
     [zeros(1,nx-3), -1 ,4, -6 , 0 ]];
 
 
 D2h0= D2h(2:(nx+1),2:(nx+1));
 
 D2g=diag(1*ones(nx,1),-1) +   ...
     diag(-2*ones(nx + 1,1)) +   ...
     diag(1*ones(nx,1),1) + ...
     [[2 , -1-11/3 ,11/3  , -3/3 , zeros(1,nx-3) ]; ...
     [-1 , 2-2/3  , -1+2/3 , zeros(1,nx-2) ];...
     zeros(nx-2,nx+1) ; ...
     [zeros(1,nx-3), -1 ,4 , -6 , 0]];
 
 D2g0= D2g(2:(nx+1),2:(nx+1));
 
 D2= diag(-ones(nx,1),-1) +   ...
     diag(2*ones(nx+1,1)) +   ...
     diag(-ones(nx,1),1) + ...
     [[0 , -4 ,  4  , -1 , zeros(1,nx-3) ]; ...
      zeros(nx-1,nx+1) ; ...
     [zeros(1,nx-3), -1 , 4 , -4 , 0]];
 
 D1= diag(-0.5*ones(nx,1),-1) +   ...
     diag(0.5*ones(nx,1),1) + ...
     [[-3/2 , -0.5+4/2 ,  -1/2  ,  zeros(1,nx-2) ]; ...
      zeros(nx-1,nx+1) ; ...
     [zeros(1,nx-2), 1/2, 0.5-4/2 , 3/2]];
 
 
 %% integral operators
 
 I0= tril(ones(nx+1,nx+1),-1) - [0.5*ones(nx+1,1) , zeros(nx+1,nx)] + diag(0.5*ones(nx+1,1));
 I1= triu(ones(nx+1,nx+1),+1) - [zeros(nx+1,nx) , 0.5*ones(nx+1,1) ] + diag(0.5*ones(nx+1,1));
 
 %% shear forces calculation (inverse problem)

h2=zeros(nx+1,ny+1);
h2ext=zeros(1,ny+1);

    
for inst=1:ny

h2(:,inst)=  (1/deltax)*(D1*u_target(:,inst))  ...
        -eta*(deltax^3)*(I1*(I0*(I0*((u_target(:,inst+1)-u_target(:,inst))/deltay))));
    
h2ext(inst)= - u_target(nx+1,inst) ;
    
end

h2(:,ny+1)=h2(:,1);
h2ext(ny+1)=h2ext(1);
   
gamma_target=zeros(nx+1,ny+1);
  
  for inst=1:(ny+1)
  gamma_target(:,inst)=deltax*I0*u_target(:,inst);
  end

   

hp=cos(phip)*h2;
hport=-sin(phip)*h2;

hextp=cos(phip)*h2ext;
hextport=-sin(phip)*h2ext;

   
 %% flagellar dynamics equations solver 
 

 gammap= zeros(nx+1,ny+1);
 gammaport= zeros(nx+1,ny+1);

 gammap(:,ny+1)=cos(phip)*gamma_target(:,1);
 gammaport(:,ny+1)=-sin(phip)*gamma_target(:,1);
  
 
 for per=1:periods
 
     gammap(:,1)=gammap(:,ny+1);
     gammaport(:,1)=gammaport(:,ny+1);
     
 for inst=1:ny
 gammap(2:(nx+1),inst+1)= (eye(nx)+ (deltay/(eta*(deltax^4)))*D40  )\...
                          (gammap(2:(nx+1),inst) + (deltay/(eta*(deltax^2)))*D2h0*hp(2:(nx+1),inst)...
                           + (deltay/(eta*(deltax^3)))*[zeros(nx-2,1); 2*hextp(inst+1) ; -8*hextp(inst+1)]);
 gammaport(2:(nx+1),inst+1)= (eye(nx)+ (deltay/(eta*(deltax^4)))*D40  )\...
                          (gammaport(2:(nx+1),inst) + (deltay/(eta*(deltax^2)))*D2h0*hport(2:(nx+1),inst)...
                           + nu*(deltay/(eta*(deltax^2)))*D2g0*gammaport(2:(nx+1),inst)...
                           + (deltay/(eta*(deltax^3)))*[zeros(nx-2,1); 2*hextport(inst+1) ; -8*hextport(inst+1)]...
                           + nu*(deltay/(eta*(deltax)))*[zeros(nx-1,1); -2*hextport(inst+1)] );

 end
 
 end
 
 
 
 u1_tar = zeros(nx+1,ny/10);
 u2_tar = zeros(nx+1,ny/10);
 u1 = zeros(nx+1,ny/10);
 u2 = zeros(nx+1,ny/10);
 
 h = zeros(nx+1,ny/10);
 hext=zeros(1,ny/10);
 
 for inst=1:(ny/10)
 u1_tar(:,inst)= 0*u_target(:,(inst-1)*10 + 1); 
 u2_tar(:,inst)= u_target(:,(inst-1)*10 + 1);
 u1(:,inst)=(1/deltax)*D1*( - cos(phip)*gammaport(:,(inst-1)*10 + 1) - sin(phip)*gammap(:,(inst-1)*10 + 1));
 u2(:,inst)=(1/deltax)*D1*( - sin(phip)*gammaport(:,(inst-1)*10 + 1) + cos(phip)*gammap(:,(inst-1)*10 + 1));
 
 h(:,inst)= h2(:,(inst-1)*10 + 1); 
 hext(inst)= h2ext((inst-1)*10 + 1); 
 

 end

 
 tor = zeros(nx+1,ny/10); % torsion
 psi=  zeros(nx+1,ny/10);
 torsmooth = zeros(nx+1,ny/10);
 kappa= zeros(nx+1,ny/10);
 
 smoothpar=0.99999;
 
 chi= (1- exp(-50*(1-x).^2))' ;
 
  for inst=1:(ny/10)
     
     psi(:,inst)=atan2(u2(:,inst),u1(:,inst));
     tor(:,inst)=((1/deltax)*D1*(atan2(u2(:,inst),u1(:,inst))));
     
       
     torsmooth(:,inst)= csaps(x ,chi.*tor(:,inst),smoothpar,x);
     kappa(:,inst)= sqrt(u1(:,inst).^2 + u2(:,inst).^2);
 end
 
 

 maxh=max(max(abs(h)));
 maxhext=max(max(abs(hext)));
 h2_norm=h/maxh;
 h2ext_norm=hext/maxhext;
 
 %% plots

 xrange = [ 0  1];
 yrange = [0   1];
 
 figure
 imagesc(xrange,yrange,u1_tar)
 colorbar
 title('U_{1}^* / L^{-1} Ax')
 xlabel('t/T')
 ylabel('s/L')
 set(gca,'YDir','normal')

 
 figure
 imagesc(xrange,yrange,u2_tar)
 colorbar
 title('U_{2}^* / L^{-1} Ax')
 xlabel('t/T')
 ylabel('s/L')
 set(gca,'YDir','normal')


 figure
 imagesc(xrange,yrange,u1)
 colorbar
 title('U_1 / L^{-1}  Ax+PFR')
 xlabel('t/T')
 ylabel('s/L')
 set(gca,'YDir','normal')

 
 figure
 imagesc(xrange,yrange,u2)
 colorbar
 title('U_2 / L^{-1} Ax+PFR')
 xlabel('t/T')
 ylabel('s/L')
 set(gca,'YDir','normal')

 
 figure
 imagesc(xrange,yrange,h2_norm)
 colorbar
 title('H_{2} /| H_{2} |_{max} ')
 xlabel('t/T')
 ylabel('s/L')
 set(gca,'YDir','normal')

 
 figure
 plot(linspace(0,1,ny/10),h2ext_norm)
 xlabel('$$t/T$$','Interpreter','latex')
 ylabel('$$\widehat{H}_{2} /| \widehat{H}_{2} |_{max}$$','Interpreter','latex')
 
 
 figure
 imagesc(xrange,yrange,torsmooth)
 colorbar
 title('\tau /L^{-1}')
 xlabel('t/T')
 ylabel('s/L')
 set(gca,'YDir','normal')

 %% flagellar shapes (integration from bending strains)
 

 r1 = zeros(nx+1,ny/10 +1);
 r2 = zeros(nx+1,ny/10 +1);
 r3 = zeros(nx+1,ny/10 +1);
 

d1=zeros(3,nx+1);
d2=zeros(3,nx+1);
d3=zeros(3,nx+1);

e1=[1,0,0];
e2=[0,1,0];
e3=[0,0,1];

 for inst=1:(ny/10 +1)
 u1(:,inst)=(1/deltax)*D1*( - cos(phip)*gammaport(:,(inst-1)*10 + 1) - sin(phip)*gammap(:,(inst-1)*10 + 1));
 u2(:,inst)=(1/deltax)*D1*( - sin(phip)*gammaport(:,(inst-1)*10 + 1) + cos(phip)*gammap(:,(inst-1)*10 + 1));
 
 
d1(:,1)= [1;0;0];
d2(:,1)= [0;1;0];
d3(:,1)= [0;0;1];

d1norm(:,1)=[1;0;0];
d2norm(:,1)=[0;1;0];

for pts=1:nx

    d1(:,pts+1)= d1(:,pts) + deltax*( 0*d2(:,pts) - u2(pts,inst)*d3(:,pts) );
    d2(:,pts+1)= d2(:,pts) + deltax*( u1(pts,inst)*d3(:,pts) - 0*d1(:,pts) );
    
    d1norm(:,pts+1)= (d1(:,pts+1) - dot(d1(:,pts+1),d2(:,pts+1))*d2(:,pts+1))/norm(d1(:,pts+1) - dot(d1(:,pts+1),d2(:,pts+1))*d2(:,pts+1));
    d2norm(:,pts+1)= d2(:,pts+1)/norm(d2(:,pts+1));
  
    d1(:,pts+1)=d1norm(:,pts+1);
    d2(:,pts+1)=d2norm(:,pts+1);
    
    d3(:,pts+1)=cross(d1norm(:,pts+1),d2norm(:,pts+1));
    
end


for pts=1:nx

    r1(pts+1,inst)= r1(pts,inst) + deltax*d3(1,pts);
    r2(pts+1,inst)= r2(pts,inst) + deltax*d3(2,pts);
    r3(pts+1,inst)= r3(pts,inst) + deltax*d3(3,pts);
    
end
 
 
 end

